#!/bin/bash

echo "=== LogicBench External Dependencies Installer ==="
echo "This script will install all external dependencies for LogicBench"
echo ""

# Function to check if command exists
command_exists() {
    command -v "$1" >/dev/null 2>&1
}

# Check if we're in the right directory
if [ ! -f "test.py" ]; then
    echo "Error: Please run this script from the LogicBench root directory"
    exit 1
fi

# 1. ABC Compilation
echo "1. Installing ABC..."
if [ ! -d "external/abc" ]; then
    echo "  Cloning ABC repository..."
    cd external/
    git clone " no link "
    cd abc/
    echo "  Compiling ABC..."
    make ABC_USE_NO_READLINE=1
    cd ../..
    echo "  ✓ ABC installed successfully"
else
    echo "  ✓ ABC already exists, skipping..."
fi

# 2. BoolFormer Models
echo " no link "
echo "2. Downloading BoolFormer models..."
cd external/boolformer/
if [ ! -f "boolformer_noiseless.pt" ]; then
    echo "  Downloading noiseless model (263MB)..."
    wget " " -O boolformer_noiseless.pt
    echo "  ✓ Noiseless model downloaded"
else
    echo "  ✓ Noiseless model already exists"
fi

if [ ! -f "boolformer_noisy.pt" ]; then
    echo "  Downloading noisy model (518MB)..."
    wget " " -O boolformer_noisy.pt
    echo "  ✓ Noisy model downloaded"
else
    echo "  ✓ Noisy model already exists"
fi
cd ../..

# 3. NeuraLUT Dependencies
echo ""
echo "3. Installing NeuraLUT dependencies..."
echo "  Installing conda packages..."
conda install -y packaging pyparsing
conda install -y docrep -c conda-forge
echo "  Installing brevitas from GitHub..."
pip install --no-cache-dir git+ " "
echo "  Installing pyverilator..."
pip install pyverilator==0.7.0
echo "  ✓ NeuraLUT dependencies installed"

# 4. DiffLogic Dependencies
echo ""
echo "4. Installing DiffLogic..."
cd external/difflogic/
echo "  Compiling DiffLogic..."
python setup.py install
cd ../..
echo "  ✓ DiffLogic installed"

# 5. PySR Dependencies
echo ""
echo "5. Installing PySR dependencies..."
echo "  Installing Julia..."
conda install -c conda-forge julia -y
echo "  Installing Julia packages..."
julia -e 'using Pkg; Pkg.add("PyCall")'
julia -e 'using Pkg; Pkg.add("SymbolicRegression")'
echo "  ✓ PySR dependencies installed"

echo ""
echo "=== Installation Complete! ==="
echo "All external dependencies have been installed successfully."
echo ""
echo "Next steps:"
echo "1. Configure your GPT API keys if needed"
echo "2. Run your LogicBench tests"
echo ""
echo "For GPT configuration, see the README.md file."
